package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Remo_chassis extends Remo_models
{
	public Remo_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Remo";
		name = getName();
		
		rID_blueprint = cars.cat_01.Remo:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_YELLOW;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 3200;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.352;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_01.Remo:0x01C6r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_01.Remo:0x01CFr; //Right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_01.Remo:0x00DBr; //Left exhaust
		parts_shop_big[1] = cars.cat_01.Remo:0x00DAr; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.remo:0x000000B9r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000BAr, "FL door", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000BBr, "FL seat", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000BCr, "FR door", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000BDr, "FR seat", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000C2r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000C6r, "L taillights", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000CAr, "R headlights", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000CCr, "R seats", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000CFr, "R taillights", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000D0r, "R windshield", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000D2r, "RL window", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000D3r, "RR window", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000D4r, "trunk", actcolor, optical, power );
			addPart( cars.cat_01.remo:0x000000DBr, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000B9r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000BAr, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000BBr, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000BCr, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000BDr, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000C2r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000C6r, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000CAr, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000CCr, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000CFr, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000D0r, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000D2r, "RL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000D3r, "RR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000D4r, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000DBr, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000B4r, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000B7r, "F grill", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000C7r, "R bumper", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.remo:0x000000B6r, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.remo:0x000000B5r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_01.remo:0x000000B4r, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.5 ) addPart( cars.cat_01.remo:0x000000B8r, "F grill 2", actcolor, optical, power ); else
			addPart( cars.cat_01.remo:0x000000B7r, "F grill", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.5 ) addPart( cars.cat_01.remo:0x000000C5r, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_01.remo:0x000000C4r, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.5 ) addPart( cars.cat_01.remo:0x000000CEr, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_01.remo:0x000000CDr, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.remo:0x000000C9r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.remo:0x000000C8r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_01.remo:0x000000C7r, "R bumper", actcolor, optical, power );
		}

		addPart( cars.cat_01.remo:0x000000D5r, "FR suspension" );
		addPart( cars.cat_01.remo:0x000000D6r, "FL suspension" );
		addPart( cars.cat_01.remo:0x000000D7r, "RL suspension" );
		addPart( cars.cat_01.remo:0x000000D8r, "RR suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );

		} else
		{
			if ( random() > 0.5 ) //Spider
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) //Sparkler
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
				}
			} else //Flat
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
				}
			}
		}

		if ( power >= 1.5 )
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.5 )
		{
/*			if ( optical >= 1.5 )
			{
				addPart( parts.running_gear:0x000001BDr, "spring" );
				addPart( parts.running_gear:0x000001BDr, "spring" );
				addPart( parts.running_gear:0x000001BEr, "spring" );
				addPart( parts.running_gear:0x000001BEr, "spring" );
			} else */
			{
				addPart( parts.running_gear:0x00000209r, "spring" );
				addPart( parts.running_gear:0x00000209r, "spring" );
				addPart( parts.running_gear:0x0000020Ar, "spring" );
				addPart( parts.running_gear:0x0000020Ar, "spring" );
			}
		} else
		{
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
		}

		if ( power >= 1.3 )
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		} else
		{
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		}

		if ( power >= 1.6 )
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}

		if ( power >= 1.75 ) addPart( parts.engines.I4:0x0000000Br, "2.5L I4 engine", actcolor, optical, (power-1.75)/0.25*2 ); else
		if ( power >= 1.5 ) addPart( parts.engines.I4:0x0000000Ar, "2.2L I4 engine", actcolor, optical, (power-1.5)/0.25*2 ); else
		if ( power >= 1.25 ) addPart( parts.engines.I4:0x00000009r, "2.0L I4 engine", actcolor, optical, (power-1.25)/0.25*2 ); else
		if ( power >= 1 ) addPart( parts.engines.I4:0x00000008r, "1.8L I4 engine", actcolor, optical, (power-1)/0.25*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.remo:0x000000BFr, "hood", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( optical-1 >= 0.66667 ) addPart( cars.cat_01.remo:0x000000C1r, "hood 3", actcolor, optical, power ); else
			if ( optical-1 >= 0.33333 ) addPart( cars.cat_01.remo:0x000000C0r, "hood 2", actcolor, optical, power ); else
			addPart( cars.cat_01.remo:0x000000BFr, "hood", actcolor, optical, power );
		}

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		addPart( cars.cat_01.Remo:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(1,0,1.0); //2WD all becomes FWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}